/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.wathe.client;

import com.google.common.collect.Maps;
import dev.doctor4t.ratatouille.client.util.OptionLocker;
import dev.doctor4t.ratatouille.client.util.ambience.AmbienceUtil;
import dev.doctor4t.ratatouille.client.util.ambience.BackgroundAmbience;
import dev.doctor4t.wathe.Wathe;
import dev.doctor4t.wathe.WatheConfig;
import dev.doctor4t.wathe.cca.GameWorldComponent;
import dev.doctor4t.wathe.cca.PlayerMoodComponent;
import dev.doctor4t.wathe.cca.TrainWorldComponent;
import dev.doctor4t.wathe.client.gui.RoundTextRenderer;
import dev.doctor4t.wathe.client.gui.StoreRenderer;
import dev.doctor4t.wathe.client.gui.TimeRenderer;
import dev.doctor4t.wathe.client.model.WatheModelLayers;
import dev.doctor4t.wathe.client.model.item.KnifeModelLoadingPlugin;
import dev.doctor4t.wathe.client.render.block_entity.PlateBlockEntityRenderer;
import dev.doctor4t.wathe.client.render.block_entity.SmallDoorBlockEntityRenderer;
import dev.doctor4t.wathe.client.render.block_entity.WheelBlockEntityRenderer;
import dev.doctor4t.wathe.client.render.entity.FirecrackerEntityRenderer;
import dev.doctor4t.wathe.client.render.entity.HornBlockEntityRenderer;
import dev.doctor4t.wathe.client.render.entity.NoteEntityRenderer;
import dev.doctor4t.wathe.client.util.WatheItemTooltips;
import dev.doctor4t.wathe.entity.FirecrackerEntity;
import dev.doctor4t.wathe.entity.NoteEntity;
import dev.doctor4t.wathe.game.GameFunctions;
import dev.doctor4t.wathe.index.WatheBlockEntities;
import dev.doctor4t.wathe.index.WatheBlocks;
import dev.doctor4t.wathe.index.WatheEntities;
import dev.doctor4t.wathe.index.WatheParticles;
import dev.doctor4t.wathe.index.WatheSounds;
import dev.doctor4t.wathe.util.AnnounceEndingPayload;
import dev.doctor4t.wathe.util.AnnounceWelcomePayload;
import dev.doctor4t.wathe.util.GunDropPayload;
import dev.doctor4t.wathe.util.HandParticleManager;
import dev.doctor4t.wathe.util.PoisonUtils;
import dev.doctor4t.wathe.util.ShootMuzzleS2CPayload;
import dev.doctor4t.wathe.util.TaskCompletePayload;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_4063;
import net.minecraft.class_5616;
import net.minecraft.class_634;
import net.minecraft.class_6344;
import net.minecraft.class_640;
import net.minecraft.class_742;
import net.minecraft.class_7923;
import net.minecraft.class_953;

public class WatheClient
implements ClientModInitializer {
    private static float soundLevel = 0.0f;
    public static HandParticleManager handParticleManager;
    public static Map<class_1657, class_243> particleMap;
    private static boolean prevGameRunning;
    public static GameWorldComponent gameComponent;
    public static TrainWorldComponent trainComponent;
    public static PlayerMoodComponent moodComponent;
    public static final Map<UUID, class_640> PLAYER_ENTRIES_CACHE;
    public static class_304 instinctKeybind;
    public static float prevInstinctLightLevel;
    public static float instinctLightLevel;

    public static boolean shouldDisableHudAndDebug() {
        class_310 client = class_310.method_1551();
        return client == null || client.field_1724 != null && !client.field_1724.method_7337() && !client.field_1724.method_7325();
    }

    public void onInitializeClient() {
        WatheConfig.init((String)"wathe", WatheConfig.class);
        handParticleManager = new HandParticleManager();
        particleMap = new HashMap<class_1657, class_243>();
        WatheParticles.registerFactories();
        EntityRendererRegistry.register(WatheEntities.SEAT, class_6344::new);
        EntityRendererRegistry.register(WatheEntities.FIRECRACKER, FirecrackerEntityRenderer::new);
        EntityRendererRegistry.register(WatheEntities.GRENADE, class_953::new);
        EntityRendererRegistry.register(WatheEntities.NOTE, NoteEntityRenderer::new);
        WatheModelLayers.initialize();
        ModelLoadingPlugin.register((ModelLoadingPlugin)new KnifeModelLoadingPlugin());
        BlockRenderLayerMap.INSTANCE.putBlocks(class_1921.method_23581(), new class_2248[]{WatheBlocks.STAINLESS_STEEL_VENT_HATCH, WatheBlocks.DARK_STEEL_VENT_HATCH, WatheBlocks.TARNISHED_GOLD_VENT_HATCH, WatheBlocks.METAL_SHEET_WALKWAY, WatheBlocks.STAINLESS_STEEL_LADDER, WatheBlocks.COCKPIT_DOOR, WatheBlocks.METAL_SHEET_DOOR, WatheBlocks.GOLDEN_GLASS_PANEL, WatheBlocks.CULLING_GLASS, WatheBlocks.STAINLESS_STEEL_WALKWAY, WatheBlocks.DARK_STEEL_WALKWAY, WatheBlocks.PANEL_STRIPES, WatheBlocks.RAIL_BEAM, WatheBlocks.TRIMMED_RAILING_POST, WatheBlocks.DIAGONAL_TRIMMED_RAILING, WatheBlocks.TRIMMED_RAILING, WatheBlocks.TRIMMED_EBONY_STAIRS, WatheBlocks.WHITE_LOUNGE_COUCH, WatheBlocks.WHITE_OTTOMAN, WatheBlocks.WHITE_TRIMMED_BED, WatheBlocks.BLUE_LOUNGE_COUCH, WatheBlocks.GREEN_LOUNGE_COUCH, WatheBlocks.BAR_STOOL, WatheBlocks.WALL_LAMP, WatheBlocks.SMALL_BUTTON, WatheBlocks.ELEVATOR_BUTTON, WatheBlocks.STAINLESS_STEEL_SPRINKLER, WatheBlocks.GOLD_SPRINKLER, WatheBlocks.GOLD_ORNAMENT, WatheBlocks.WHEEL, WatheBlocks.RUSTED_WHEEL, WatheBlocks.BARRIER_PANEL, WatheBlocks.FOOD_PLATTER, WatheBlocks.DRINK_TRAY, WatheBlocks.LIGHT_BARRIER, WatheBlocks.HORN});
        BlockRenderLayerMap.INSTANCE.putBlocks(class_1921.method_23583(), new class_2248[]{WatheBlocks.RHOMBUS_GLASS, WatheBlocks.PRIVACY_GLASS_PANEL, WatheBlocks.CULLING_BLACK_HULL, WatheBlocks.CULLING_WHITE_HULL, WatheBlocks.HULL_GLASS, WatheBlocks.RHOMBUS_HULL_GLASS});
        CustomModelProvider customModelProvider = new CustomModelProvider();
        ModelLoadingPlugin.register((ModelLoadingPlugin)customModelProvider);
        class_5616.method_32144(WatheBlockEntities.SMALL_GLASS_DOOR, ctx -> new SmallDoorBlockEntityRenderer(Wathe.id("textures/entity/small_glass_door.png"), ctx));
        class_5616.method_32144(WatheBlockEntities.SMALL_WOOD_DOOR, ctx -> new SmallDoorBlockEntityRenderer(Wathe.id("textures/entity/small_wood_door.png"), ctx));
        class_5616.method_32144(WatheBlockEntities.ANTHRACITE_STEEL_DOOR, ctx -> new SmallDoorBlockEntityRenderer(Wathe.id("textures/entity/anthracite_steel_door.png"), ctx));
        class_5616.method_32144(WatheBlockEntities.KHAKI_STEEL_DOOR, ctx -> new SmallDoorBlockEntityRenderer(Wathe.id("textures/entity/khaki_steel_door.png"), ctx));
        class_5616.method_32144(WatheBlockEntities.MAROON_STEEL_DOOR, ctx -> new SmallDoorBlockEntityRenderer(Wathe.id("textures/entity/maroon_steel_door.png"), ctx));
        class_5616.method_32144(WatheBlockEntities.MUNTZ_STEEL_DOOR, ctx -> new SmallDoorBlockEntityRenderer(Wathe.id("textures/entity/muntz_steel_door.png"), ctx));
        class_5616.method_32144(WatheBlockEntities.NAVY_STEEL_DOOR, ctx -> new SmallDoorBlockEntityRenderer(Wathe.id("textures/entity/navy_steel_door.png"), ctx));
        class_5616.method_32144(WatheBlockEntities.WHEEL, ctx -> new WheelBlockEntityRenderer(Wathe.id("textures/entity/wheel.png"), ctx));
        class_5616.method_32144(WatheBlockEntities.RUSTED_WHEEL, ctx -> new WheelBlockEntityRenderer(Wathe.id("textures/entity/rusted_wheel.png"), ctx));
        class_5616.method_32144(WatheBlockEntities.BEVERAGE_PLATE, PlateBlockEntityRenderer::new);
        class_5616.method_32144(WatheBlockEntities.HORN, HornBlockEntityRenderer::new);
        AmbienceUtil.registerBackgroundAmbience((BackgroundAmbience)new BackgroundAmbience(WatheSounds.AMBIENT_TRAIN_INSIDE, player -> WatheClient.isTrainMoving() && !Wathe.isSkyVisibleAdjacent((class_1297)player), 20));
        AmbienceUtil.registerBackgroundAmbience((BackgroundAmbience)new BackgroundAmbience(WatheSounds.AMBIENT_TRAIN_OUTSIDE, player -> WatheClient.isTrainMoving() && Wathe.isSkyVisibleAdjacent((class_1297)player), 20));
        AmbienceUtil.registerBackgroundAmbience((BackgroundAmbience)new BackgroundAmbience(WatheSounds.AMBIENT_PSYCHO_DRONE, player -> gameComponent.isPsychoActive(), 20));
        ClientTickEvents.START_WORLD_TICK.register(clientWorld -> {
            gameComponent = (GameWorldComponent)GameWorldComponent.KEY.get((Object)clientWorld);
            trainComponent = (TrainWorldComponent)TrainWorldComponent.KEY.get((Object)clientWorld);
            moodComponent = (PlayerMoodComponent)PlayerMoodComponent.KEY.get((Object)class_310.method_1551().field_1724);
        });
        OptionLocker.overrideOption((String)"gamma", (Object)0.0);
        OptionLocker.overrideOption((String)"renderDistance", (Object)WatheClient.getLockedRenderDistance(WatheConfig.ultraPerfMode));
        OptionLocker.overrideOption((String)"showSubtitles", (Object)false);
        OptionLocker.overrideOption((String)"autoJump", (Object)false);
        OptionLocker.overrideOption((String)"renderClouds", (Object)class_4063.field_18162);
        OptionLocker.overrideSoundCategoryVolume((String)"music", (double)0.0);
        OptionLocker.overrideSoundCategoryVolume((String)"record", (double)0.1);
        OptionLocker.overrideSoundCategoryVolume((String)"weather", (double)1.0);
        OptionLocker.overrideSoundCategoryVolume((String)"block", (double)1.0);
        OptionLocker.overrideSoundCategoryVolume((String)"hostile", (double)1.0);
        OptionLocker.overrideSoundCategoryVolume((String)"neutral", (double)1.0);
        OptionLocker.overrideSoundCategoryVolume((String)"player", (double)1.0);
        OptionLocker.overrideSoundCategoryVolume((String)"ambient", (double)1.0);
        OptionLocker.overrideSoundCategoryVolume((String)"voice", (double)1.0);
        WatheItemTooltips.addTooltips();
        ClientTickEvents.START_WORLD_TICK.register(clientWorld -> {
            class_742 player2;
            prevInstinctLightLevel = instinctLightLevel;
            instinctLightLevel = WatheClient.isInstinctEnabled() ? (instinctLightLevel += 0.1f) : (instinctLightLevel -= 0.1f);
            instinctLightLevel = class_3532.method_15363((float)instinctLightLevel, (float)-0.04f, (float)0.5f);
            for (class_742 player2 : clientWorld.method_18456()) {
                class_634 networkHandler = class_310.method_1551().method_1562();
                if (networkHandler == null) continue;
                PLAYER_ENTRIES_CACHE.put(player2.method_5667(), networkHandler.method_2871(player2.method_5667()));
            }
            if (!prevGameRunning && gameComponent.isRunning()) {
                class_310.method_1551().field_1724.method_31548().field_7545 = 8;
            }
            prevGameRunning = gameComponent.isRunning();
            GameWorldComponent component = (GameWorldComponent)GameWorldComponent.KEY.get((Object)clientWorld);
            if (component.getFade() > 0) {
                class_310.method_1551().method_1483().method_4865(class_3419.field_15250, class_3532.method_37959((float)component.getFade(), (float)0.0f, (float)40.0f, (float)soundLevel, (float)0.0f));
            } else {
                class_310.method_1551().method_1483().method_4865(class_3419.field_15250, soundLevel);
                soundLevel = class_310.method_1551().field_1690.method_1630(class_3419.field_15250);
            }
            player2 = class_310.method_1551().field_1724;
            if (player2 != null) {
                StoreRenderer.tick();
                TimeRenderer.tick();
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            handParticleManager.tick();
            RoundTextRenderer.tick();
        });
        ClientPlayNetworking.registerGlobalReceiver(ShootMuzzleS2CPayload.ID, (ClientPlayNetworking.PlayPayloadHandler)new ShootMuzzleS2CPayload.Receiver());
        ClientPlayNetworking.registerGlobalReceiver(PoisonUtils.PoisonOverlayPayload.ID, (ClientPlayNetworking.PlayPayloadHandler)new PoisonUtils.PoisonOverlayPayload.Receiver());
        ClientPlayNetworking.registerGlobalReceiver(GunDropPayload.ID, (ClientPlayNetworking.PlayPayloadHandler)new GunDropPayload.Receiver());
        ClientPlayNetworking.registerGlobalReceiver(AnnounceWelcomePayload.ID, (ClientPlayNetworking.PlayPayloadHandler)new AnnounceWelcomePayload.Receiver());
        ClientPlayNetworking.registerGlobalReceiver(AnnounceEndingPayload.ID, (ClientPlayNetworking.PlayPayloadHandler)new AnnounceEndingPayload.Receiver());
        ClientPlayNetworking.registerGlobalReceiver(TaskCompletePayload.ID, (ClientPlayNetworking.PlayPayloadHandler)new TaskCompletePayload.Receiver());
        instinctKeybind = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.wathe.instinct", class_3675.class_307.field_1668, 342, "category.wathe.keybinds"));
    }

    public static TrainWorldComponent getTrainComponent() {
        return trainComponent;
    }

    public static float getTrainSpeed() {
        return trainComponent.getSpeed();
    }

    public static boolean isTrainMoving() {
        return trainComponent != null && trainComponent.getSpeed() > 0;
    }

    public static boolean isPlayerAliveAndInSurvival() {
        return GameFunctions.isPlayerAliveAndSurvival((class_1657)class_310.method_1551().field_1724);
    }

    public static boolean isPlayerSpectatingOrCreative() {
        return GameFunctions.isPlayerSpectatingOrCreative((class_1657)class_310.method_1551().field_1724);
    }

    public static boolean isKiller() {
        return gameComponent != null && gameComponent.canUseKillerFeatures((class_1657)class_310.method_1551().field_1724);
    }

    public static int getInstinctHighlight(class_1297 target) {
        if (!WatheClient.isInstinctEnabled()) {
            return -1;
        }
        if (target instanceof class_1542 || target instanceof NoteEntity || target instanceof FirecrackerEntity) {
            return 14392576;
        }
        if (target instanceof class_1657) {
            class_1657 player = (class_1657)target;
            if (GameFunctions.isPlayerSpectatingOrCreative(player)) {
                return -1;
            }
            if (WatheClient.isKiller() && gameComponent.canUseKillerFeatures(player)) {
                return class_3532.method_15369((float)0.0f, (float)1.0f, (float)0.6f);
            }
            if (gameComponent.isInnocent(player)) {
                float mood = ((PlayerMoodComponent)PlayerMoodComponent.KEY.get((Object)target)).getMood();
                if (mood < 0.2f) {
                    return 1514950;
                }
                if (mood < 0.55f) {
                    return 0x1FAFAF;
                }
                return 5168437;
            }
            if (WatheClient.isPlayerSpectatingOrCreative()) {
                return 0xFFFFFF;
            }
        }
        return -1;
    }

    public static boolean isInstinctEnabled() {
        return instinctKeybind.method_1434() && (WatheClient.isKiller() && WatheClient.isPlayerAliveAndInSurvival() || WatheClient.isPlayerSpectatingOrCreative());
    }

    public static int getLockedRenderDistance(boolean ultraPerfMode) {
        return ultraPerfMode ? 2 : 32;
    }

    static {
        PLAYER_ENTRIES_CACHE = Maps.newHashMap();
        prevInstinctLightLevel = -0.04f;
        instinctLightLevel = -0.04f;
    }

    public static class CustomModelProvider
    implements ModelLoadingPlugin {
        private final Map<class_2960, class_1100> modelIdToBlock = new Object2ObjectOpenHashMap();
        private final Set<class_2960> withInventoryVariant = new HashSet<class_2960>();

        public void register(class_2248 block, class_1100 model) {
            this.register(class_7923.field_41175.method_10221((Object)block), model);
        }

        public void register(class_2960 id, class_1100 model) {
            this.modelIdToBlock.put(id, model);
        }

        public void markInventoryVariant(class_2248 block) {
            this.markInventoryVariant(class_7923.field_41175.method_10221((Object)block));
        }

        public void markInventoryVariant(class_2960 id) {
            this.withInventoryVariant.add(id);
        }

        public void onInitializeModelLoader(ModelLoadingPlugin.Context ctx) {
            ctx.modifyModelOnLoad().register((model, context) -> {
                class_1091 topLevelId = context.topLevelId();
                if (topLevelId == null) {
                    return model;
                }
                class_2960 id = topLevelId.comp_2875();
                if (topLevelId.method_4740().equals("inventory") && !this.withInventoryVariant.contains(id)) {
                    return model;
                }
                if (this.modelIdToBlock.containsKey(id)) {
                    return this.modelIdToBlock.get(id);
                }
                return model;
            });
        }
    }
}

